<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\Understand\Assistant\Intent;

use Twilio\ListResource;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class IntentActionsList extends ListResource {
    /**
     * Construct the IntentActionsList
     * 
     * @param Version $version Version that contains the resource
     * @param string $assistantSid The assistant_sid
     * @param string $intentSid The intent_sid
     * @return \Twilio\Rest\Preview\Understand\Assistant\Intent\IntentActionsList 
     */
    public function __construct(Version $version, $assistantSid, $intentSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array('assistantSid' => $assistantSid, 'intentSid' => $intentSid, );
    }

    /**
     * Constructs a IntentActionsContext
     * 
     * @return \Twilio\Rest\Preview\Understand\Assistant\Intent\IntentActionsContext 
     */
    public function getContext() {
        return new IntentActionsContext(
            $this->version,
            $this->solution['assistantSid'],
            $this->solution['intentSid']
        );
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Preview.Understand.IntentActionsList]';
    }
}