<?php $__env->startSection('style'); ?>
    <?php echo Html::style("assets/libs/bootstrap-datetimepicker/css/bootstrap-datetimepicker.min.css"); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('Update Period',Auth::guard('client')->user()->lan_id)); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">
                <div class="col-lg-6">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Update Period',Auth::guard('client')->user()->lan_id)); ?></h3>
                        </div>
                        <div class="panel-body">

                            <form class="" role="form" method="post" action="<?php echo e(url('user/sms/post-update-recurring-sms')); ?>">
                                <?php echo e(csrf_field()); ?>



                                <div class="form-group">
                                    <label><?php echo e(language_data('SMS Gateway',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <select class="selectpicker form-control" name="sms_gateway" data-live-search="true">
                                        <?php $__currentLoopData = $sms_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if($sg->id == $recurring->use_gateway): ?> selected <?php endif; ?> value="<?php echo e($sg->id); ?>"><?php echo e($sg->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Sender ID',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" name="sender_id" id="sender_id" value="<?php echo e($recurring->sender); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Recurring Period',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <select class="selectpicker form-control" id="period" name="period">
                                        <option value="day" <?php if($recurring->recurring == 'day'): ?> selected <?php endif; ?>><?php echo e(language_data('Daily',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="week1" <?php if($recurring->recurring == 'week1'): ?> selected <?php endif; ?>><?php echo e(language_data('Weekly',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="weeks2"  <?php if($recurring->recurring == 'weeks2'): ?> selected <?php endif; ?>><?php echo e(language_data('2 Weeks',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="month1"  <?php if($recurring->recurring == 'month1'): ?> selected <?php endif; ?>><?php echo e(language_data('Month',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="months2"  <?php if($recurring->recurring == 'months2'): ?> selected <?php endif; ?>><?php echo e(language_data('2 Months',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="months3"  <?php if($recurring->recurring == 'months3'): ?> selected <?php endif; ?>><?php echo e(language_data('3 Months',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="months6"  <?php if($recurring->recurring == 'months6'): ?> selected <?php endif; ?>><?php echo e(language_data('6 Months',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="year1"  <?php if($recurring->recurring == 'year1'): ?> selected <?php endif; ?>><?php echo e(language_data('Year',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="years2"  <?php if($recurring->recurring == 'years2'): ?> selected <?php endif; ?>><?php echo e(language_data('2 Years',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="years3"  <?php if($recurring->recurring == 'years3'): ?> selected <?php endif; ?>><?php echo e(language_data('3 Years',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="0" <?php if($recurring->recurring == '0'): ?> selected <?php endif; ?>><?php echo e(language_data('Custom Date',Auth::guard('client')->user()->lan_id)); ?></option>
                                    </select>
                                </div>

                                <div class="form-group recurring-time">
                                    <label><?php echo e(language_data('Recurring Time',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control timePicker" name="recurring_time" value="<?php echo e(date('h:i A', strtotime($recurring->recurring_date))); ?>">
                                </div>


                                <div class="schedule_time">
                                    <div class="form-group">
                                        <label><?php echo e(language_data('Schedule Time',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <input type="text" class="form-control dateTimePicker" name="schedule_time" value="<?php echo e(date('m/d/Y h:i A',strtotime($recurring->recurring_date))); ?>">
                                    </div>
                                </div>
                                <input type="hidden" value="<?php echo e($recurring->id); ?>" name="cmd">
                                <button type="submit" class="btn btn-success btn-sm" name="action" value="send_now"><i class="fa fa-save"></i> <?php echo e(language_data('Update',Auth::guard('client')->user()->lan_id)); ?> </button>
                            </form>

                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/libs/moment/moment.min.js"); ?>

    <?php echo Html::script("assets/libs/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>


    <script>
      $(document).ready(function () {
        var period = $('#period');

        if (period.val() == 0){
          $('.schedule_time').show()
          $('.recurring-time').hide()
        }else {
          $('.schedule_time').hide()
          $('.recurring-time').show()
        }

        period.on('change', function () {
          if (this.value == 0) {
            $('.schedule_time').show()
            $('.recurring-time').hide()
          } else {
            $('.schedule_time').hide()
            $('.recurring-time').show()
          }
        })
      });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('client', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>