<?php $__env->startSection('style'); ?>
    <?php echo Html::style("assets/libs/data-table/datatables.min.css"); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30 clearfix">
            <h2 class="page-title inline-block"><?php echo e(language_data('SMS Templates',Auth::guard('client')->user()->lan_id)); ?></h2>

            <a href="<?php echo e(url('user/sms/create-sms-template')); ?>" class="btn btn-success btn-sm pull-right"><i class="fa fa-plus"></i> <?php echo e(language_data('Create Template',Auth::guard('client')->user()->lan_id)); ?></a>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">

                <div class="col-lg-12">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('SMS Templates',Auth::guard('client')->user()->lan_id)); ?></h3>
                        </div>
                        <div class="panel-body p-none">
                            <table class="table data-table table-hover">
                                <thead>
                                <tr>
                                    <th style="width: 10%;"><?php echo e(language_data('SL',Auth::guard('client')->user()->lan_id)); ?>#</th>
                                    <th style="width: 45%;"><?php echo e(language_data('Template Name',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 10%;"><?php echo e(language_data('Global',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 10%;"><?php echo e(language_data('Status',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 25%;"><?php echo e(language_data('Action',Auth::guard('client')->user()->lan_id)); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $sms_templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="SL"><?php echo e($loop->iteration); ?></td>
                                        <td data-label="Sender ID"><p><?php echo e($st->template_name); ?></p></td>

                                        <?php if($st->global=='yes'): ?>
                                            <td data-label="global"><p class="label label-success"><?php echo e(language_data('Yes',Auth::guard('client')->user()->lan_id)); ?></p></td>
                                        <?php else: ?>
                                            <td data-label="Status"><p class="label label-danger"><?php echo e(language_data('No',Auth::guard('client')->user()->lan_id)); ?></p></td>
                                        <?php endif; ?>
                                        <?php if($st->status=='active'): ?>
                                            <td data-label="Status"><p class="label label-success"><?php echo e(language_data('Active',Auth::guard('client')->user()->lan_id)); ?></p></td>
                                        <?php else: ?>
                                            <td data-label="Status"><p class="label label-danger"><?php echo e(language_data('Inactive',Auth::guard('client')->user()->lan_id)); ?></p></td>
                                        <?php endif; ?>
                                        <td data-label="Actions">
                                            <?php if($st->cl_id!=0): ?>
                                            <a class="btn btn-success btn-xs" href="<?php echo e(url('user/sms/manage-sms-template/'.$st->id)); ?>" ><i class="fa fa-edit"></i> <?php echo e(language_data('Manage',Auth::guard('client')->user()->lan_id)); ?></a>
                                            <a href="#" class="btn btn-danger btn-xs cdelete" id="<?php echo e($st->id); ?>"><i class="fa fa-trash"></i> <?php echo e(language_data('Delete',Auth::guard('client')->user()->lan_id)); ?></a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

    <?php echo Html::script("assets/libs/data-table/datatables.min.js"); ?>

    <?php echo Html::script("assets/js/bootbox.min.js"); ?>


    <script>
        $(document).ready(function(){

          $('.data-table').DataTable({
            language: {
              url: '<?php echo url("assets/libs/data-table/i18n/".get_language_code(Auth::guard('client')->user()->lan_id)->language.".lang"); ?>'
            },
            responsive: true
          })

            /*For Delete Sender ID*/
            $( "body" ).delegate( ".cdelete", "click",function (e) {
                e.preventDefault();
                var id = this.id;
              bootbox.confirm("<?php echo language_data('Are you sure',Auth::guard('client')->user()->lan_id); ?> ?", function (result) {
                    if (result) {
                        var _url = $("#_url").val();
                        window.location.href = _url + "/user/sms/delete-sms-template/" + id;
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('client', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>