<?php $__env->startSection('style'); ?>
    <?php echo Html::style("assets/libs/data-table/datatables.min.css"); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('Administrator Roles')); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">

                <div class="col-lg-4">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"> <?php echo e(language_data('Add Administrator Role')); ?></h3>
                        </div>
                        <div class="panel-body">
                            <form class="" role="form" method="post" action="<?php echo e(url('administrators/add-role')); ?>">
                                <div class="form-group">
                                    <label><?php echo e(language_data('Role Name')); ?></label>
                                    <input type="text" class="form-control" required name="role_name">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Status')); ?></label>
                                    <select class="selectpicker form-control" name="status">
                                        <option value="Active"><?php echo e(language_data('Active')); ?></option>
                                        <option value="Inactive"><?php echo e(language_data('Inactive')); ?></option>
                                    </select>
                                </div>

                                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                <button type="submit" class="btn btn-success btn-sm pull-right"><i class="fa fa-plus"></i> <?php echo e(language_data('Add')); ?> </button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Administrator Roles')); ?></h3>
                        </div>
                        <div class="panel-body p-none">
                            <table class="table data-table table-hover">
                                <thead>
                                <tr>
                                    <th style="width: 10%;"><?php echo e(language_data('SL')); ?>#</th>
                                    <th style="width: 35%;"><?php echo e(language_data('Role Name')); ?></th>
                                    <th style="width: 15%;"><?php echo e(language_data('Status')); ?></th>
                                    <th style="width: 40%;"><?php echo e(language_data('Action')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $admin_roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $er): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="<?php echo e(language_data('SL')); ?>"><?php echo e($loop->iteration); ?></td>
                                        <td data-label="<?php echo e(language_data('Role Name')); ?>"><p><?php echo e($er->role_name); ?></p></td>
                                        <?php if($er->status=='Active'): ?>
                                            <td data-label="<?php echo e(language_data('Status')); ?>"><span class="label label-success"><?php echo e(language_data('Active')); ?></span></td>
                                        <?php else: ?>
                                            <td data-label="<?php echo e(language_data('Status')); ?>"><span class="label label-danger"><?php echo e(language_data('Inactive')); ?></span></td>
                                        <?php endif; ?>
                                        <td data-label="<?php echo e(language_data('Action')); ?>">

                                            <a class="btn btn-success btn-xs" href="#" data-toggle="modal" data-target=".modal_edit_administrator_roles_<?php echo e($er->id); ?>"><i class="fa fa-edit"></i> <?php echo e(language_data('Edit')); ?></a>
                                            <?php echo $__env->make('admin.modal-edit-administrator-roles', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                            <a class="btn btn-complete btn-xs" href="<?php echo e(url('administrators/set-role/'.$er->id)); ?>"><i class="fa fa-list"></i> <?php echo e(language_data('Set Roles')); ?></a>

                                            <a href="#" class="btn btn-danger btn-xs cdelete" id="<?php echo e($er->id); ?>"><i class="fa fa-trash"></i> <?php echo e(language_data('Delete')); ?></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

    <?php echo Html::script("assets/libs/data-table/datatables.min.js"); ?>

    <?php echo Html::script("assets/js/bootbox.min.js"); ?>

    <script>
        $(document).ready(function(){
            $('.data-table').DataTable({
              language: {
                url: '<?php echo url("assets/libs/data-table/i18n/".get_language_code()->language.".lang"); ?>'
              },
              responsive: true
            });


            /*For Delete role*/
            $( "body" ).delegate( ".cdelete", "click",function (e) {
                e.preventDefault();
                var id = this.id;
                bootbox.confirm("<?php echo language_data('Are you sure'); ?>?", function (result) {
                    if (result) {
                        var _url = $("#_url").val();
                        window.location.href = _url + "/administrators/delete-role/" + id;
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>