<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('Localization')); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">

            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">

                <div class="col-lg-6">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"> <?php echo e(language_data('Localization')); ?></h3>
                        </div>
                        <div class="panel-body">
                            <form class="" role="form" action="<?php echo e(url('settings/localization-post')); ?>" method="post">
                                <div class="form-group">
                                    <label for="Country"><?php echo e(language_data('Default Country')); ?></label>
                                    <select name="country" class="form-control selectpicker" data-live-search="true">
                                        <?php echo countries(app_config('Country')); ?>

                                    </select>
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Date Format')); ?></label>
                                    <select class="form-control selectpicker" data-live-search="true" name="date_format">
                                        <option value="d/m/Y" <?php if(app_config('DateFormat') == 'd/m/Y'): ?> selected="selected" <?php endif; ?>>15/05/2016</option>
                                        <option value="d.m.Y" <?php if(app_config('DateFormat') == 'd.m.Y'): ?> selected="selected" <?php endif; ?>>15.05.2016</option>
                                        <option value="d-m-Y" <?php if(app_config('DateFormat') == 'd-m-Y'): ?> selected="selected" <?php endif; ?>>15-05-2016</option>
                                        <option value="m/d/Y" <?php if(app_config('DateFormat') == 'm/d/Y'): ?> selected="selected" <?php endif; ?>>05/15/2016</option>
                                        <option value="Y/m/d" <?php if(app_config('DateFormat') == 'Y/m/d'): ?> selected="selected" <?php endif; ?>>2016/05/15</option>
                                        <option value="Y-m-d" <?php if(app_config('DateFormat') == 'Y-m-d'): ?> selected="selected" <?php endif; ?>>2016-05-15</option>
                                        <option value="M d Y" <?php if(app_config('DateFormat') == 'M d Y'): ?> selected="selected" <?php endif; ?>>May 15 2016</option>
                                        <option value="d M Y" <?php if(app_config('DateFormat') == 'd M Y'): ?> selected="selected" <?php endif; ?>>15 May 2016</option>
                                        <option value="jS M y" <?php if(app_config('DateFormat') == 'jS M y'): ?> selected="selected" <?php endif; ?>>15th May 16</option>
                                    </select>
                                </div>


                                <div class="form-group">
                                    <label for="tzone"><?php echo e(language_data('Timezone')); ?></label>
                                    <select name="timezone" class="form-control selectpicker" data-live-search="true">
                                        <?php $__currentLoopData = timezoneList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($value); ?>" <?php if(config('app.timezone')==$value): ?> selected <?php endif; ?>><?php echo e($label); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Send SMS')); ?> <?php echo e(language_data('Country Code')); ?></label>
                                    <select class="selectpicker form-control" name="country_code" data-live-search="true">
                                        <option value="0"><?php echo e(language_data('Exist on phone number')); ?></option>
                                        <?php $__currentLoopData = $country_code; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($code->country_code); ?>" <?php if(app_config('send_sms_country_code') == $code->country_code): ?> selected <?php endif; ?> ><?php echo e($code->country_name); ?> (<?php echo e($code->country_code); ?>)</option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Default Language')); ?></label>
                                    <select class="form-control selectpicker" name="language">
                                        <?php $__currentLoopData = $language_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($l->id); ?>"><?php echo e($l->language); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Currency Code')); ?></label>
                                    <input type="text" class="form-control" required name="currency_code" value="<?php echo e(app_config('Currency')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Currency Symbol')); ?></label>
                                    <input type="text" class="form-control" required name="currency_symbol" value="<?php echo e(app_config('CurrencyCode')); ?>">
                                </div>


                                <div class="form-group">
                                    <label for="currency_symbol_position"><?php echo e(language_data('Currency Symbol Position')); ?></label>
                                    <select class="form-control selectpicker" name="currency_symbol_position">
                                        <option value="left" <?php if(app_config('currency_symbol_position') == 'left'): ?> selected="selected" <?php endif; ?>><?php echo e(language_data('Left')); ?></option>
                                        <option value="right" <?php if(app_config('currency_symbol_position') == 'right'): ?> selected="selected" <?php endif; ?>><?php echo e(language_data('Right')); ?></option>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="cformat"><?php echo e(language_data('Currency Format')); ?></label>
                                    <select class="form-control selectpicker" name="cformat">
                                        <option value="1" <?php if(app_config('dec_point') == '.' AND app_config('thousands_sep') == ''): ?> selected="selected" <?php endif; ?>>1234.56</option>
                                        <option value="2" <?php if(app_config('dec_point') == '.' AND app_config('thousands_sep') == ','): ?>  selected="selected" <?php endif; ?>>1,234.56</option>
                                        <option value="3" <?php if(app_config('dec_point') == ',' AND app_config('thousands_sep') == ''): ?> selected="selected" <?php endif; ?>>1234,56</option>
                                        <option value="4" <?php if(app_config('dec_point') == ',' AND app_config('thousands_sep') == '.'): ?>  selected="selected" <?php endif; ?>>1.234,56</option>
                                    </select>
                                </div>


                                <div class="form-group">
                                    <label for="currency_decimal_digits"><?php echo e(language_data('Currency Decimal Digits')); ?></label>
                                    <select class="form-control selectpicker" name="currency_decimal_digits">
                                        <option value="0" <?php if(app_config('currency_decimal_digits') == '0'): ?>  selected="selected" <?php endif; ?>>0 (e.g. 100)</option>
                                        <option value="1" <?php if(app_config('currency_decimal_digits') == '1'): ?> selected="selected" <?php endif; ?>>1 (e.g. 100.0)</option>
                                        <option value="2" <?php if(app_config('currency_decimal_digits') == '2'): ?> selected="selected" <?php endif; ?>>2 (e.g. 100.00)</option>
                                        <option value="3" <?php if(app_config('currency_decimal_digits') == '3'): ?> selected="selected" <?php endif; ?>>3 (e.g. 100.000)</option>
                                        <option value="4" <?php if(app_config('currency_decimal_digits') == '4'): ?> selected="selected" <?php endif; ?>>4 (e.g. 100.0000)</option>
                                    </select>
                                </div>

                                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                <button type="submit" class="btn btn-success btn-sm pull-right"><i class="fa fa-save"></i> <?php echo e(language_data('Update')); ?></button>
                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>