<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('Add New Client',Auth::guard('client')->user()->lan_id)); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">
                <div class="col-lg-6">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Add New Client',Auth::guard('client')->user()->lan_id)); ?></h3>
                        </div>
                        <div class="panel-body">
                            <form class="" role="form" method="post" action="<?php echo e(url('user/post-new-user')); ?>" enctype="multipart/form-data">
                                <?php echo e(csrf_field()); ?>




                                <div class="form-group">
                                    <label><?php echo e(language_data('First Name',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" required name="first_name" value="<?php echo e(old('first_name')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Last Name',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" name="last_name" value="<?php echo e(old('last_name')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Company',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" name="company" value="<?php echo e(old('company')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Website',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="url" class="form-control" name="website" value="<?php echo e(old('website')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Email',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="email" class="form-control" name="email" value="<?php echo e(old('email')); ?>" required>
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('User name',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" required name="user_name" value="<?php echo e(old('user_name')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Password',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="password" class="form-control" required name="password" value="<?php echo e(old('password')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Confirm Password',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="password" class="form-control" required name="cpassword" value="<?php echo e(old('cpassword')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Phone',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" required name="phone" value="<?php echo e(old('phone')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Address',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" name="address" value="<?php echo e(old('address')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('More Address',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" name="more_address" value="<?php echo e(old('more_address')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('State',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" name="state" value="<?php echo e(old('state')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('City',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" name="city" value="<?php echo e(old('city')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Postcode',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" name="postcode" value="<?php echo e(old('postcode')); ?>">
                                </div>

                                <div class="form-group">
                                    <label for="Country"><?php echo e(language_data('Country',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <select name="country" class="form-control selectpicker" data-live-search="true">
                                        <?php echo countries(app_config('Country')); ?>

                                    </select>
                                </div>

                                <?php if(\Auth::guard('client')->user()->reseller=='Yes'): ?>

                                    <div class="form-group">
                                        <label><?php echo e(language_data('Reseller Panel',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <select class="selectpicker form-control" name="reseller_panel">
                                            <option value="Yes"><?php echo e(language_data('Yes',Auth::guard('client')->user()->lan_id)); ?></option>
                                            <option value="No"><?php echo e(language_data('No',Auth::guard('client')->user()->lan_id)); ?></option>
                                        </select>
                                    </div>

                                <?php endif; ?>

                                <?php if(\Auth::guard('client')->user()->api_access=='Yes'): ?>
                                <div class="form-group">
                                    <label><?php echo e(language_data('Api Access',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <select class="selectpicker form-control" name="api_access">
                                        <option value="Yes"><?php echo e(language_data('Yes',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <option value="No"><?php echo e(language_data('No',Auth::guard('client')->user()->lan_id)); ?></option>
                                    </select>
                                </div>
                                <?php endif; ?>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Client Group',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <select class="selectpicker form-control" name="client_group"  data-live-search="true">
                                        <option value="0"><?php echo e(language_data('None',Auth::guard('client')->user()->lan_id)); ?></option>
                                        <?php $__currentLoopData = $clientGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($cg->id); ?>"><?php echo e($cg->group_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('SMS Gateway',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <select class="selectpicker form-control" name="sms_gateway[]"  data-live-search="true" multiple>
                                        <?php $__currentLoopData = $sms_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($sg->id); ?>"><?php echo e($sg->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>


                                <div class="form-group">
                                    <label><?php echo e(language_data('SMS Limit',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" name="sms_limit" required value="<?php echo e(old('sms_limit')); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Avatar',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <div class="form-group input-group input-group-file">
                                        <span class="input-group-btn">
                                            <span class="btn btn-primary btn-file">
                                                <?php echo e(language_data('Browse')); ?> <input type="file" class="form-control" name="image" accept="image/*">
                                            </span>
                                        </span>
                                        <input type="text" class="form-control" readonly="">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="coder-checkbox">
                                        <input type="checkbox" checked="" value="yes" name="email_notify">
                                        <span class="co-check-ui"></span>
                                        <label><?php echo e(language_data('Notify Client with email',Auth::guard('client')->user()->lan_id)); ?></label>
                                    </div>
                                </div>

                                <button type="submit" class="btn btn-success btn-sm pull-right"><i class="fa fa-plus"></i> <?php echo e(language_data('Add',Auth::guard('client')->user()->lan_id)); ?> </button>
                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('client', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>