<?php $__env->startSection('style'); ?>
    <?php echo Html::style("assets/libs/data-table/datatables.min.css"); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('Phone Book',Auth::guard('client')->user()->lan_id)); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">

                <div class="col-lg-4">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Add New List',Auth::guard('client')->user()->lan_id)); ?></h3>
                        </div>
                        <div class="panel-body">
                            <form class="" role="form" method="post" action="<?php echo e(url('user/post-phone-book')); ?>">

                                <div class="form-group">
                                    <label><?php echo e(language_data('List name',Auth::guard('client')->user()->lan_id)); ?></label>
                                    <input type="text" class="form-control" name="list_name">
                                </div>

                                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                <button type="submit" class="btn btn-success btn-sm pull-right"><i class="fa fa-plus"></i> <?php echo e(language_data('Add',Auth::guard('client')->user()->lan_id)); ?> </button>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Phone Book',Auth::guard('client')->user()->lan_id)); ?></h3>
                        </div>
                        <div class="panel-body p-none">
                            <table class="table data-table table-hover">
                                <thead>
                                <tr>
                                    <th style="width: 10%"><?php echo e(language_data('SL',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 35%"><?php echo e(language_data('List name',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 55%"><?php echo e(language_data('Action',Auth::guard('client')->user()->lan_id)); ?></th>
                                </tr>
                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $clientGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <p><?php echo e($loop->iteration); ?></p>
                                        </td>
                                        <td>
                                            <p><?php echo e($cg->group_name); ?> </p>
                                        </td>
                                        <td>

                                            <a href="<?php echo e(url('user/view-contact/'.$cg->id)); ?>" class="btn btn-primary btn-xs"><i class="fa fa-eye"></i> <?php echo e(language_data('View Contacts',Auth::guard('client')->user()->lan_id)); ?></a>
                                            <a href="<?php echo e(url('user/add-contact/'.$cg->id)); ?>" class="btn btn-complete btn-xs"><i class="fa fa-plus"></i> <?php echo e(language_data('Add Contact',Auth::guard('client')->user()->lan_id)); ?></a>
                                            <a class="btn btn-success btn-xs" href="#" data-toggle="modal" data-target=".modal_edit_list_<?php echo e($cg->id); ?>"><i class="fa fa-edit"></i> <?php echo e(language_data('Edit',Auth::guard('client')->user()->lan_id)); ?></a>
                                            <?php echo $__env->make('client.modal-edit-contact-list', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                                            <a href="#" class="btn btn-danger btn-xs cdelete" id="<?php echo e($cg->id); ?>"><i class="fa fa-trash"></i> <?php echo e(language_data('Delete',Auth::guard('client')->user()->lan_id)); ?></a>
                                        </td>
                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

    <?php echo Html::script("assets/libs/data-table/datatables.min.js"); ?>

    <?php echo Html::script("assets/js/bootbox.min.js"); ?>


    <script>
        $(document).ready(function(){

          $('.data-table').DataTable({
            language: {
              url: '<?php echo url("assets/libs/data-table/i18n/".get_language_code(Auth::guard('client')->user()->lan_id)->language.".lang"); ?>'
            },
            responsive: true
          })

            /*For Delete Group*/
            $( "body" ).delegate( ".cdelete", "click",function (e) {
                e.preventDefault();
                var id = this.id;
              bootbox.confirm("<?php echo language_data('Are you sure',Auth::guard('client')->user()->lan_id); ?> ?", function (result) {
                    if (result) {
                        var _url = $("#_url").val();
                        window.location.href = _url + "/user/sms/delete-import-phone-number/" + id;
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('client', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>