@extends('layouts/contentLayoutMaster')

@section('title', __('locale.menu.Subscriptions'))

@section('page-style')
    {{-- Page Css files --}}
    <link rel="stylesheet" type="text/css" href="{{asset('css/pages/pricing.css')}}">
@endsection

@section('content')
    <!-- pricing table -->
    <div id="pricing-table">
        <div class="pricing-table-wrapper mt-2 pt-2">
            @foreach($plans->chunk(3) as $chunk)
                <div class="row">
                    <div class="col-xl-3 col-lg-12 col-xxl-3 align-self-center pr-xl-0">
                        <!-- pricing legend starts here -->
                        <div class="pricing-legend">
                            <!-- pricing lengend card -->
                            <div class="card">
                                <div class="card-content">
                                    <div class="pricing-legend-inner text-center pt-4 pb-2">
                                        <!-- card top area starts-->
                                        <div class="card-top-area-wrapper">
                                            <div class="card-top-area">
                                                <svg enable-background="new 0 0 512 512" class="plan-svg" viewBox="0 0 512 512"
                                                     xml:space="preserve" xmlns="http://www.w3.org/2000/svg"
                                                     xmlns:xlink="http://www.w3.org/1999/xlink">
                      <g id="Layer_3"/>
                                                    <g>
                                                        <g>
                                                            <path
                                                                    d="M400.2,170.1h-89.4c13.9-10,22.5-23.7,23.6-36.9c1.2-13.9-6.6-30.3-31.7-34.5c-2.8-0.5-5.6-0.7-8.3-0.7    c-10.9,0-19.9,4-26.7,11.8c-6.4,7.3-9.9,17.2-11.8,27.2c-1.9-10-5.5-20-11.8-27.2C237.4,102,228.4,98,217.5,98    c-2.6,0-5.4,0.2-8.3,0.7c-25.1,4.2-32.8,20.6-31.7,34.5c1.1,13.2,9.8,26.9,23.6,36.9h-89.4c-12.5,0-22.6,10.1-22.6,22.6V207    c0,12.5,10.1,22.6,22.6,22.6h6.6v156.4c0,15.5,12.6,28.1,28.1,28.1h219.1c15.5,0,28.1-12.6,28.1-28.1V229.6h6.6    c12.5,0,22.6-10.1,22.6-22.6v-14.3C422.8,180.2,412.7,170.1,400.2,170.1z M279.1,119.6c3.9-4.5,8.9-6.6,15.4-6.6    c1.8,0,3.8,0.2,5.8,0.5c7.6,1.3,20.3,5.4,19.2,18.5c-1.2,14.5-19.6,35.1-50.2,37.8C268.3,155.7,269,131.3,279.1,119.6z M192.5,132    c-1.1-13.1,11.6-17.2,19.2-18.5c2-0.3,4-0.5,5.8-0.5c6.5,0,11.5,2.2,15.4,6.6c10.1,11.6,10.8,36,9.8,50.2    C212.1,167.1,193.7,146.5,192.5,132z M378.6,385.9c0,7.2-5.9,13.1-13.1,13.1H146.4c-7.2,0-13.1-5.9-13.1-13.1V229.6h245.2V385.9z     M407.8,207c0,4.2-3.4,7.6-7.6,7.6h-14.1H125.9h-14.1c-4.2,0-7.6-3.4-7.6-7.6v-14.3c0-4.2,3.4-7.6,7.6-7.6h288.4    c4.2,0,7.6,3.4,7.6,7.6V207z"/>
                                                            <path
                                                                    d="M216.8,301.9c14.8,0,26.8-12,26.8-26.8c0-14.8-12-26.8-26.8-26.8s-26.8,12-26.8,26.8C190,289.9,202,301.9,216.8,301.9z     M216.8,263.3c6.5,0,11.8,5.3,11.8,11.8s-5.3,11.8-11.8,11.8s-11.8-5.3-11.8-11.8S210.3,263.3,216.8,263.3z"/>
                                                            <path
                                                                    d="M295.2,326.6c-14.8,0-26.8,12-26.8,26.8s12,26.8,26.8,26.8s26.8-12,26.8-26.8S310,326.6,295.2,326.6z M295.2,365.3    c-6.5,0-11.8-5.3-11.8-11.8s5.3-11.8,11.8-11.8s11.8,5.3,11.8,11.8S301.7,365.3,295.2,365.3z"/>
                                                            <path
                                                                    d="M197.4,372.9c1.5,1.5,3.4,2.2,5.3,2.2s3.8-0.7,5.3-2.2l106.6-106.6c2.9-2.9,2.9-7.7,0-10.6c-2.9-2.9-7.7-2.9-10.6,0    L197.4,362.3C194.4,365.2,194.4,370,197.4,372.9z"/>
                                                        </g>
                                                    </g>
                    </svg>
                                                <div class="header-text pb-2">
                                                    <div class="heading-primary-text font-weight-bolder">{{ config('app.name') }}</div>
                                                    <div class="sub-heading-text font-weight-bold">{{ __('locale.plans.plan_features') }}</div>
                                                </div>

                                            </div>
                                        </div>
                                        <!-- card top area ends -->
                                        <!-- limits area starts -->

                                        <div class="plan-limits mt-3 pb-75">

                                            <div class="d-flex align-items-center justify-content-center font-weight-bold text-truncate common-height text-uppercase">
                                                <span class="d-none d-xl-block">{{ __('locale.labels.sms_credit') }}</span>
                                            </div>

                                            <div class="d-flex align-items-center justify-content-center font-weight-bold text-truncate common-height text-uppercase">
                                                <span class="d-none d-xl-block">{{ __('locale.plans.create_own_sending_server') }}</span>
                                            </div>


                                            <div class="d-flex align-items-center justify-content-center font-weight-bold text-truncate common-height text-uppercase">
                                                <span class="d-none d-xl-block">{{__('locale.customer.sender_id_verification')}}</span>
                                            </div>

                                            <div class="d-flex align-items-center justify-content-center font-weight-bold text-truncate common-height text-uppercase">
                                                <span class="d-none d-xl-block">{{ __('locale.labels.api_access') }}</span>
                                            </div>

                                            <div class="d-flex align-items-center justify-content-center font-weight-bold text-truncate common-height text-uppercase">
                                                <span class="d-none d-xl-block">{{__('locale.labels.text_messages')}}</span>
                                            </div>

                                            <div class="d-flex align-items-center justify-content-center font-weight-bold text-truncate common-height text-uppercase">
                                                <span class="d-none d-xl-block">{{__('locale.labels.voice_messages')}}</span>
                                            </div>

                                            <div class="d-flex align-items-center justify-content-center font-weight-bold text-truncate common-height text-uppercase">
                                                <span class="d-none d-xl-block">{{__('locale.labels.picture_messages')}}</span>
                                            </div>
                                        </div>
                                        <!-- limit area ends -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- pricing legend ends here -->
                    </div>
                    <div class="col-xl-9 col-lg-12 col-xxl-9 pl-xl-0">
                        <!-- pricing plans starts here -->
                        <div class="pricing-plans">
                            <div class="row">
                                @foreach($chunk as $plan)
                                    <div class="col-md-12 col-lg-4 col-xl-4 {{ $loop->first ? null : "pl-lg-0" }} pr-lg-0">
                                        <!-- premium plan card-->
                                        <div class="card
                                            {{ $plan->is_popular ? "primium-plan-card rounded border-primary hightlight-bestvalue": null }}">
                                            <div class="card-content text-center">
                                                <!-- premium plan starts -->
                                                <div class="primium-plan">
                                                    <div class="primium-plan-inner text-center {{ $plan->is_popular ? "pt-5 mb-1 px-2 pb-2 mt-50" : "pt-4 px-2 pb-2" }}">
                                                        <!-- premium card top area stars -->
                                                        <div class="card-top-area-wrapper">
                                                            <div class="card-top-area">
                                                                <svg id="Layer_4" class="common-svg"
                                                                     viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg"
                                                                     xmlns:xlink="http://www.w3.org/1999/xlink">
                            <style type="text/css"></style>
                                                                    <g>
                                                                        <path class="st0"
                                                                              d="M42.5,444.1H340c3.9,19,48.3,24.2,75,24.2c28,0,75.3-5.7,75.3-27V385v-56.3v-56.4c0-21.3-47.3-27-75.3-27   c-26.1,0-69.1,5-74.7,22.9c-5-13.3-10.7-25.5-17-36.5c-12.3-21.6-27.1-38.6-43.9-50.6c2.6-1.5,5.1-3.4,7.3-5.6   c6.5-6.5,10.1-15.1,10.1-24.4c0-19-15.5-34.4-34.5-34.4h-8.5c6.5-12.7,21.4-35.1,49.5-46.3c4.8-1.9,7.8-6.7,7.8-12.5   c0-8-6.3-14.3-14.3-14.3H126c-6.6,0-12.1,4.3-13.9,10.7c-1.7,6.2,0.9,12.5,6.4,15.7c31.9,18.5,45.3,36.6,50.7,46.7h-8.9   c-9.2,0-17.9,3.6-24.4,10.1c-6.5,6.5-10.1,15.2-10.1,24.4c0,12.8,7,24,17.4,29.9c-60.6,43.1-79.5,139.9-85.4,198.1l-28,23.5   c-7.6,6.3-10.2,17.2-6.7,27C26.4,438.6,33.8,444.1,42.5,444.1z M355.1,289.8c0.1,0.1,0.3,0.1,0.4,0.2c0.4,0.2,0.7,0.3,1.1,0.5   c0.1,0.1,0.3,0.1,0.4,0.2c0.4,0.2,0.8,0.3,1.3,0.5c0.1,0,0.2,0.1,0.3,0.1c0.5,0.2,1,0.4,1.6,0.6c0.1,0,0.2,0.1,0.4,0.1   c0.4,0.1,0.8,0.3,1.2,0.4c0.2,0.1,0.3,0.1,0.5,0.2c0.4,0.1,0.9,0.3,1.3,0.4c0.1,0,0.2,0.1,0.4,0.1c0.6,0.2,1.1,0.3,1.7,0.5   c0.1,0,0.2,0.1,0.3,0.1c0.5,0.1,0.9,0.3,1.4,0.4c0.2,0,0.3,0.1,0.5,0.1c0.4,0.1,0.9,0.2,1.3,0.3c0.1,0,0.3,0.1,0.4,0.1   c0.6,0.1,1.2,0.3,1.8,0.4c0.1,0,0.2,0,0.2,0.1c0.5,0.1,1,0.2,1.6,0.3c0.2,0,0.4,0.1,0.5,0.1c0.5,0.1,0.9,0.2,1.4,0.3   c0.2,0,0.3,0.1,0.5,0.1c0.6,0.1,1.2,0.2,1.8,0.3c0,0,0,0,0.1,0c0.6,0.1,1.2,0.2,1.8,0.3c0.2,0,0.4,0.1,0.5,0.1   c0.5,0.1,0.9,0.1,1.4,0.2c0.2,0,0.4,0.1,0.6,0.1c0.6,0.1,1.2,0.2,1.7,0.3c0,0,0.1,0,0.1,0c0.6,0.1,1.2,0.2,1.9,0.3   c0.2,0,0.4,0,0.5,0.1c0.5,0.1,0.9,0.1,1.4,0.2c0.2,0,0.4,0,0.6,0.1c0.5,0.1,1.1,0.1,1.6,0.2c0.1,0,0.2,0,0.3,0   c0.6,0.1,1.2,0.1,1.9,0.2c0.2,0,0.3,0,0.5,0.1c0.5,0,0.9,0.1,1.4,0.1c0.2,0,0.4,0,0.6,0.1c0.5,0,1,0.1,1.4,0.1c0.1,0,0.3,0,0.4,0   c0.6,0.1,1.2,0.1,1.8,0.1c0.1,0,0.3,0,0.4,0c0.5,0,0.9,0.1,1.4,0.1c0.2,0,0.4,0,0.6,0c0.5,0,0.9,0.1,1.4,0.1c0.2,0,0.3,0,0.5,0   c0.6,0,1.2,0.1,1.8,0.1c0.1,0,0.2,0,0.4,0c0.5,0,0.9,0,1.4,0.1c0.2,0,0.4,0,0.6,0c0.4,0,0.9,0,1.3,0c0.2,0,0.3,0,0.5,0   c0.6,0,1.1,0,1.7,0c0.1,0,0.1,0,0.2,0c0.5,0,1,0,1.5,0c0.2,0,0.3,0,0.5,0c0.4,0,0.8,0,1.2,0c0.2,0,0.3,0,0.5,0c0.5,0,1.1,0,1.6,0   s1,0,1.6,0c0.2,0,0.3,0,0.5,0c0.4,0,0.8,0,1.2,0c0.2,0,0.3,0,0.5,0c0.5,0,0.9,0,1.4,0c0.1,0,0.2,0,0.3,0c0.5,0,1.1,0,1.7,0   c0.2,0,0.3,0,0.5,0c0.4,0,0.8,0,1.2,0c0.2,0,0.4,0,0.6,0c0.4,0,0.9,0,1.3-0.1c0.1,0,0.3,0,0.4,0c0.6,0,1.2-0.1,1.7-0.1   c0.2,0,0.4,0,0.5,0c0.4,0,0.9-0.1,1.3-0.1c0.2,0,0.4,0,0.6,0c0.4,0,0.9-0.1,1.3-0.1c0.2,0,0.3,0,0.5,0c0.6,0,1.2-0.1,1.8-0.1   c0.2,0,0.4,0,0.5,0c0.4,0,0.9-0.1,1.3-0.1c0.2,0,0.5,0,0.7-0.1c0.4,0,0.8-0.1,1.2-0.1c0.2,0,0.4,0,0.6-0.1c0.6-0.1,1.2-0.1,1.8-0.2   c0.2,0,0.3,0,0.5-0.1c0.5-0.1,0.9-0.1,1.4-0.2c0.2,0,0.5-0.1,0.7-0.1c0.4-0.1,0.8-0.1,1.2-0.2c0.2,0,0.4-0.1,0.7-0.1   c0.6-0.1,1.2-0.2,1.7-0.2c0.1,0,0.3,0,0.4-0.1c0.5-0.1,1-0.1,1.5-0.2c0.2,0,0.5-0.1,0.7-0.1c0.4-0.1,0.8-0.1,1.2-0.2   c0.2,0,0.5-0.1,0.7-0.1c0.5-0.1,1-0.2,1.5-0.3c0.1,0,0.3-0.1,0.4-0.1c0.6-0.1,1.1-0.2,1.7-0.3c0.2,0,0.4-0.1,0.6-0.1   c0.4-0.1,0.8-0.2,1.2-0.2c0.2,0,0.4-0.1,0.7-0.1c0.5-0.1,0.9-0.2,1.4-0.3c0.1,0,0.3-0.1,0.4-0.1c0.6-0.1,1.1-0.3,1.7-0.4   c0.2,0,0.4-0.1,0.6-0.1c0.4-0.1,0.8-0.2,1.2-0.3c0.2-0.1,0.4-0.1,0.6-0.2c0.4-0.1,0.8-0.2,1.2-0.3c0.2,0,0.3-0.1,0.5-0.1   c0.5-0.2,1.1-0.3,1.6-0.5c0.2,0,0.3-0.1,0.5-0.1c0.4-0.1,0.8-0.2,1.2-0.4c0.2-0.1,0.4-0.1,0.6-0.2c0.4-0.1,0.8-0.3,1.2-0.4   c0.1-0.1,0.3-0.1,0.4-0.2c0.5-0.2,1-0.4,1.5-0.6c0.1,0,0.2-0.1,0.3-0.1c0.4-0.2,0.8-0.3,1.2-0.5c0.2-0.1,0.3-0.1,0.5-0.2   c0.4-0.1,0.7-0.3,1.1-0.5c0.1-0.1,0.3-0.1,0.4-0.2c0.5-0.2,0.9-0.4,1.4-0.6c0,0,0,0,0,0v39.4c0,0.1-0.1,0.2-0.1,0.2   c0,0,0,0.1-0.1,0.1c-0.1,0.1-0.1,0.2-0.2,0.2c0,0.1-0.1,0.1-0.1,0.2c-0.1,0.1-0.2,0.2-0.3,0.3c-0.1,0.1-0.1,0.1-0.2,0.2   c-0.1,0.1-0.2,0.2-0.3,0.3c-0.1,0.1-0.2,0.1-0.2,0.2c-0.1,0.1-0.2,0.1-0.3,0.2c-0.1,0.1-0.2,0.2-0.3,0.3c-0.1,0.1-0.2,0.2-0.4,0.2   c-0.1,0.1-0.3,0.2-0.4,0.3c-0.1,0.1-0.3,0.2-0.4,0.2c-0.2,0.1-0.3,0.2-0.5,0.3c-0.1,0.1-0.2,0.1-0.4,0.2c-0.2,0.1-0.4,0.2-0.6,0.3   c-0.1,0.1-0.3,0.1-0.4,0.2c-0.2,0.1-0.5,0.2-0.7,0.3c-0.1,0.1-0.2,0.1-0.3,0.2c-0.3,0.1-0.6,0.3-0.9,0.4c-0.1,0.1-0.3,0.1-0.4,0.2   c-0.3,0.1-0.6,0.2-0.9,0.4c-0.1,0-0.2,0.1-0.3,0.1c-0.4,0.1-0.7,0.3-1.1,0.4c-0.1,0-0.2,0.1-0.3,0.1c-0.4,0.1-0.8,0.3-1.2,0.4   c-0.2,0.1-0.4,0.1-0.5,0.2c-0.4,0.1-0.7,0.2-1.1,0.4c-0.2,0-0.3,0.1-0.5,0.1c-0.4,0.1-0.8,0.3-1.3,0.4c-0.2,0.1-0.4,0.1-0.7,0.2   c-0.4,0.1-0.8,0.2-1.2,0.3c-0.2,0.1-0.4,0.1-0.6,0.2c-0.5,0.1-0.9,0.2-1.4,0.4c-0.2,0-0.4,0.1-0.6,0.1c-0.5,0.1-1,0.2-1.5,0.4   c-0.2,0.1-0.5,0.1-0.7,0.2c-0.5,0.1-1,0.2-1.5,0.3c-0.3,0.1-0.5,0.1-0.8,0.2c-0.5,0.1-1,0.2-1.5,0.3c-0.3,0.1-0.6,0.1-0.9,0.2   c-0.5,0.1-1,0.2-1.5,0.3c-0.3,0.1-0.6,0.1-0.9,0.1c-0.5,0.1-1.1,0.2-1.6,0.3c-0.3,0.1-0.7,0.1-1.1,0.2c-0.5,0.1-1,0.2-1.6,0.2   c-0.4,0.1-0.8,0.1-1.3,0.2c-0.5,0.1-1,0.1-1.5,0.2c-0.3,0-0.6,0.1-0.9,0.1c-0.6,0.1-1.3,0.2-1.9,0.2c-0.3,0-0.6,0.1-0.9,0.1   c-0.7,0.1-1.4,0.1-2,0.2c-0.2,0-0.5,0-0.7,0.1c-0.8,0.1-1.5,0.1-2.3,0.2c-0.3,0-0.7,0-1,0.1c-0.7,0.1-1.4,0.1-2.2,0.1   c-0.3,0-0.6,0-0.8,0c-0.8,0-1.6,0.1-2.5,0.1c-1.8,0.1-3.7,0.1-5.6,0.2c-1.6,0-3.2,0.1-4.9,0.1c-0.5,0-1.1,0-1.6,0c0,0-0.1,0-0.1,0   c-0.4,0-0.9,0-1.3,0c0,0-0.1,0-0.1,0c-2.1,0-4.4-0.1-7-0.2l-2.6-0.1c-1.3-0.1-2.5-0.1-3.9-0.3c-0.5,0-1-0.1-1.5-0.1   c0,0-0.1,0-0.1,0c-1.4-0.1-2.8-0.2-4.1-0.4c-0.1,0-0.1,0-0.2,0c-0.5,0-1-0.1-1.4-0.2c0,0-0.1,0-0.1,0c-2.2-0.2-4.4-0.5-6.4-0.8   c0,0-0.1,0-0.1,0c-0.2,0-0.5-0.1-0.7-0.1c-0.1,0-0.1,0-0.2,0c-2.3-0.4-4.5-0.8-6.6-1.2c0,0-0.1,0-0.1,0c-0.7-0.1-1.4-0.3-2.1-0.4   c0,0-0.1,0-0.1,0c-0.5-0.1-0.9-0.2-1.4-0.3c-1.4-0.3-2.5-0.6-3.4-0.9l-1.4-0.4c-0.9-0.3-1.7-0.5-2.5-0.8c-0.4-0.1-0.8-0.3-1.3-0.4   c0,0-0.1,0-0.1,0c-0.2-0.1-0.5-0.2-0.7-0.3c-0.3-0.1-0.5-0.2-0.8-0.3c-0.1,0-0.2-0.1-0.4-0.1c-0.2-0.1-0.5-0.2-0.7-0.3   c-0.5-0.2-1.1-0.5-1.6-0.7c-0.1,0-0.1-0.1-0.2-0.1c-0.3-0.2-0.7-0.3-1-0.5l-0.3-0.1c-0.4-0.2-0.9-0.5-1.4-0.7   c-0.1-0.1-0.3-0.1-0.5-0.3c-0.2-0.1-0.3-0.2-0.5-0.3c-0.1,0-0.1-0.1-0.2-0.1c-0.1-0.1-0.2-0.1-0.3-0.2c-0.1-0.1-0.3-0.2-0.4-0.3   c-0.2-0.1-0.3-0.3-0.5-0.4c-0.1-0.1-0.2-0.2-0.4-0.3c0,0-0.1-0.1-0.1-0.1c-0.1-0.1-0.1-0.1-0.2-0.2l-0.1-0.1c0-0.1-0.1-0.1-0.1-0.2   c-0.3-0.3-0.5-0.5-0.5-0.6c0,0,0,0,0-0.1c0,0,0-0.1,0-0.1v-15.3v-24.1c0,0,0,0,0,0C354.2,289.3,354.6,289.5,355.1,289.8z    M476.3,345.4v39.4c0,0.1-0.1,0.2-0.1,0.3c0,0,0,0.1-0.1,0.1c-0.1,0.1-0.2,0.2-0.2,0.3c0,0,0,0.1-0.1,0.1c-0.1,0.1-0.2,0.2-0.4,0.4   c0,0,0,0-0.1,0.1c-0.2,0.1-0.3,0.3-0.5,0.4c0,0,0,0,0,0c-3.9,3.1-15.1,7.6-33.5,9.9c-0.1,0-0.2,0-0.4,0c-0.8,0.1-1.7,0.2-2.6,0.3   c-0.1,0-0.2,0-0.3,0c-0.8,0.1-1.5,0.2-2.3,0.2c-0.2,0-0.4,0-0.6,0.1c-1,0.1-2,0.2-3,0.3c0,0,0,0-0.1,0c-1,0.1-2,0.1-3,0.2   c-0.1,0-0.1,0-0.2,0c-4.3,0.3-8.9,0.4-13.9,0.4c-11.4,0-22.6-0.9-32.3-2.5c-0.7-0.1-1.3-0.2-2-0.3c-0.1,0-0.1,0-0.2,0   c-1.9-0.3-3.7-0.7-5.3-1.1c-0.1,0-0.2,0-0.3-0.1c-0.5-0.1-0.9-0.2-1.4-0.3c0,0-0.1,0-0.1,0c-1-0.2-2-0.5-2.9-0.7c0,0,0,0,0,0   c-1-0.3-1.9-0.5-2.7-0.8c-0.1,0-0.2-0.1-0.3-0.1c-0.3-0.1-0.7-0.2-1-0.3c-0.1,0-0.2-0.1-0.3-0.1c-0.3-0.1-0.6-0.2-0.9-0.3   c-0.1,0-0.1,0-0.2-0.1c-0.3-0.1-0.6-0.2-1-0.3c-0.1,0-0.1,0-0.2-0.1c-0.3-0.1-0.6-0.2-0.9-0.3c-0.1,0-0.2-0.1-0.3-0.1   c-0.2-0.1-0.5-0.2-0.7-0.3c-0.1,0-0.1-0.1-0.2-0.1c-0.3-0.1-0.5-0.2-0.7-0.3c-0.1,0-0.2-0.1-0.2-0.1c-0.2-0.1-0.4-0.2-0.6-0.3   c-0.1,0-0.2-0.1-0.3-0.1c-0.2-0.1-0.4-0.2-0.5-0.3c-0.1,0-0.2-0.1-0.3-0.1c-0.2-0.1-0.3-0.2-0.5-0.2c-0.1,0-0.2-0.1-0.3-0.1   c-0.1-0.1-0.3-0.1-0.4-0.2c-0.1-0.1-0.2-0.1-0.3-0.2c-0.1-0.1-0.2-0.1-0.4-0.2c-0.1,0-0.1-0.1-0.2-0.1c-0.1-0.1-0.2-0.1-0.3-0.2   c-0.1,0-0.1-0.1-0.2-0.1c-0.1-0.1-0.2-0.1-0.3-0.2c-0.1,0-0.1-0.1-0.2-0.1c-0.1-0.1-0.2-0.1-0.3-0.2c-0.1,0-0.1-0.1-0.1-0.1   c-0.1-0.1-0.2-0.1-0.3-0.2c-0.1,0-0.1-0.1-0.2-0.1c-0.1-0.1-0.1-0.1-0.2-0.2c-0.1,0-0.1-0.1-0.1-0.1c-0.1-0.1-0.1-0.1-0.2-0.2   c0,0-0.1-0.1-0.1-0.1c-0.1,0-0.1-0.1-0.2-0.1c0,0-0.1-0.1-0.1-0.1c0,0-0.1-0.1-0.1-0.1c0,0,0-0.1-0.1-0.1c0,0-0.1-0.1-0.1-0.1   c0,0,0-0.1-0.1-0.1c0,0-0.1-0.1-0.1-0.1c0,0,0,0,0-0.1c0,0-0.1-0.1-0.1-0.1c0,0,0,0,0,0c0,0,0-0.1-0.1-0.1v-39.4   c0.3,0.1,0.5,0.3,0.8,0.4c0,0,0,0,0,0c0,0,0,0,0,0c0,0,0.1,0,0.1,0c0,0,0,0,0,0c0.7,0.3,1.3,0.6,1.9,0.8c0,0,0,0,0.1,0c0,0,0,0,0,0   c0.7,0.3,1.4,0.5,2.1,0.8c0,0,0,0,0,0c0,0,0,0,0.1,0c0.4,0.2,0.8,0.3,1.2,0.4c0.3,0.1,0.7,0.2,1.1,0.4c0.1,0,0.1,0,0.2,0.1   c0,0,0,0,0.1,0c0,0,0,0,0,0c0,0,0,0,0,0c1.1,0.4,2.2,0.7,3,0.9c0.3,0.1,0.6,0.2,1,0.3l0.5,0.2c0,0,0,0,0,0c1.1,0.3,2.4,0.6,3.9,1   c0.6,0.1,1.1,0.3,1.7,0.4c0.8,0.2,1.6,0.4,2.5,0.5c1.4,0.3,3,0.6,4.5,0.9c0.9,0.2,1.8,0.3,2.7,0.4c0.4,0.1,0.7,0.1,1.1,0.2   c1.3,0.2,2.7,0.4,4.1,0.6c0.9,0.1,1.9,0.2,2.8,0.3c0.6,0.1,1.3,0.2,1.9,0.2c1.6,0.2,3,0.3,4.4,0.4c0.6,0.1,1.2,0.1,1.7,0.1   c1.3,0.1,2.7,0.2,4,0.3c0.3,0,0.7,0,1,0.1l0.8,0c0.1,0,0.1,0,0.2,0l0.9,0c2.7,0.1,5.1,0.2,7.3,0.2c0.5,0,1,0,1.5,0   c0.6,0,1.2,0,1.8,0c0.5,0,1,0,1.6,0c0.2,0,0.3,0,0.5,0c0.4,0,0.8,0,1.2,0c0.2,0,0.3,0,0.5,0c0.5,0,0.9,0,1.4,0c0.1,0,0.2,0,0.3,0   c0.6,0,1.1,0,1.7,0c0.2,0,0.3,0,0.5,0c0.4,0,0.8,0,1.3,0c0.2,0,0.4,0,0.6,0c0.5,0,0.9,0,1.4-0.1c0.1,0,0.3,0,0.4,0   c0.6,0,1.2-0.1,1.7-0.1c0.2,0,0.3,0,0.5,0c0.4,0,0.9-0.1,1.3-0.1c0.2,0,0.4,0,0.6,0c0.4,0,0.9-0.1,1.3-0.1c0.2,0,0.3,0,0.5,0   c0.6,0,1.2-0.1,1.8-0.1c0.2,0,0.3,0,0.5,0c0.4,0,0.9-0.1,1.3-0.1c0.2,0,0.5,0,0.7-0.1c0.4,0,0.8-0.1,1.3-0.1c0.2,0,0.4,0,0.6-0.1   c0.6-0.1,1.2-0.1,1.8-0.2c0.2,0,0.3,0,0.5-0.1c0.5-0.1,0.9-0.1,1.4-0.2c0.2,0,0.5-0.1,0.7-0.1c0.4-0.1,0.8-0.1,1.2-0.2   c0.2,0,0.4-0.1,0.7-0.1c0.6-0.1,1.2-0.2,1.8-0.2c0.1,0,0.2,0,0.3-0.1c0.5-0.1,1-0.1,1.5-0.2c0.2,0,0.5-0.1,0.7-0.1   c0.4-0.1,0.8-0.1,1.2-0.2c0.2,0,0.5-0.1,0.7-0.1c0.5-0.1,1-0.2,1.5-0.3c0.1,0,0.2,0,0.4-0.1c0.6-0.1,1.1-0.2,1.7-0.3   c0.2,0,0.4-0.1,0.6-0.1c0.4-0.1,0.8-0.2,1.2-0.2c0.2,0,0.4-0.1,0.7-0.1c0.5-0.1,0.9-0.2,1.4-0.3c0.1,0,0.3-0.1,0.4-0.1   c0.6-0.1,1.1-0.3,1.7-0.4c0.2,0,0.4-0.1,0.6-0.1c0.4-0.1,0.8-0.2,1.2-0.3c0.2-0.1,0.4-0.1,0.6-0.2c0.4-0.1,0.8-0.2,1.3-0.3   c0.1,0,0.3-0.1,0.4-0.1c0.5-0.2,1.1-0.3,1.6-0.5c0.2,0,0.3-0.1,0.5-0.1c0.4-0.1,0.8-0.2,1.2-0.4c0.2-0.1,0.4-0.1,0.6-0.2   c0.4-0.1,0.8-0.3,1.2-0.4c0.1-0.1,0.3-0.1,0.4-0.2c0.5-0.2,1-0.4,1.5-0.6c0.1,0,0.2-0.1,0.3-0.1c0.4-0.2,0.8-0.3,1.2-0.5   c0.2-0.1,0.3-0.1,0.5-0.2c0.4-0.1,0.7-0.3,1.1-0.4c0.1-0.1,0.3-0.1,0.4-0.2C475.4,345.9,475.8,345.7,476.3,345.4   C476.3,345.5,476.3,345.5,476.3,345.4z M476.3,441.2c-1.7,3.8-22,13.2-61.3,13.2c-39.3,0-59.6-9.3-61.3-13.2v-4.1v-35.4   c0.1,0,0.1,0.1,0.2,0.1c0.9,0.4,1.7,0.8,2.6,1.2c0.1,0.1,0.3,0.1,0.4,0.2c0.9,0.4,1.8,0.7,2.8,1.1c0.1,0,0.3,0.1,0.4,0.1   c1,0.3,1.9,0.7,2.9,1c0.1,0,0.2,0.1,0.4,0.1c1,0.3,2,0.6,3.1,0.9c0.1,0,0.2,0.1,0.3,0.1c1,0.3,2.1,0.6,3.2,0.8c0.1,0,0.2,0,0.3,0.1   c1.1,0.3,2.2,0.5,3.2,0.7c0.1,0,0.1,0,0.2,0c1.1,0.2,2.2,0.5,3.3,0.7c0,0,0.1,0,0.1,0c1.1,0.2,2.2,0.4,3.3,0.6   c10.5,1.7,22.5,2.7,34.6,2.7c0.5,0,1,0,1.6,0c0.2,0,0.3,0,0.5,0c0.4,0,0.8,0,1.2,0c0.2,0,0.3,0,0.5,0c0.5,0,0.9,0,1.4,0   c0.1,0,0.2,0,0.3,0c0.5,0,1.1,0,1.7,0c0.2,0,0.3,0,0.5,0c0.4,0,0.8,0,1.2,0c0.2,0,0.4,0,0.6,0c0.4,0,0.9,0,1.3-0.1   c0.1,0,0.3,0,0.4,0c0.6,0,1.2-0.1,1.7-0.1c0.2,0,0.4,0,0.5,0c0.4,0,0.9-0.1,1.3-0.1c0.2,0,0.4,0,0.6,0c0.4,0,0.9-0.1,1.3-0.1   c0.2,0,0.3,0,0.5,0c0.6,0,1.2-0.1,1.8-0.1c0.2,0,0.4,0,0.5,0c0.4,0,0.9-0.1,1.3-0.1c0.2,0,0.5,0,0.7-0.1c0.4,0,0.8-0.1,1.2-0.1   c0.2,0,0.4,0,0.6-0.1c0.6-0.1,1.2-0.1,1.8-0.2c0.2,0,0.3,0,0.5-0.1c0.5-0.1,0.9-0.1,1.4-0.2c0.2,0,0.5-0.1,0.7-0.1   c0.4-0.1,0.8-0.1,1.2-0.2c0.2,0,0.4-0.1,0.7-0.1c0.6-0.1,1.2-0.2,1.7-0.2c0.1,0,0.3,0,0.4-0.1c0.5-0.1,1-0.1,1.5-0.2   c0.2,0,0.5-0.1,0.7-0.1c0.4-0.1,0.8-0.1,1.2-0.2c0.2,0,0.5-0.1,0.7-0.1c0.5-0.1,1-0.2,1.5-0.3c0.1,0,0.3-0.1,0.4-0.1   c0.6-0.1,1.1-0.2,1.7-0.3c0.2,0,0.4-0.1,0.6-0.1c0.4-0.1,0.8-0.2,1.2-0.2c0.2,0,0.4-0.1,0.7-0.1c0.5-0.1,0.9-0.2,1.4-0.3   c0.1,0,0.3-0.1,0.4-0.1c0.6-0.1,1.1-0.3,1.7-0.4c0.2,0,0.4-0.1,0.6-0.1c0.4-0.1,0.8-0.2,1.2-0.3c0.2-0.1,0.4-0.1,0.6-0.2   c0.4-0.1,0.8-0.2,1.2-0.3c0.2,0,0.3-0.1,0.5-0.1c0.5-0.2,1.1-0.3,1.6-0.5c0.2,0,0.3-0.1,0.5-0.1c0.4-0.1,0.8-0.2,1.2-0.4   c0.2-0.1,0.4-0.1,0.6-0.2c0.4-0.1,0.8-0.3,1.2-0.4c0.1-0.1,0.3-0.1,0.4-0.2c0.5-0.2,1-0.4,1.5-0.6c0.1,0,0.2-0.1,0.3-0.1   c0.4-0.2,0.8-0.3,1.2-0.5c0.2-0.1,0.3-0.1,0.5-0.2c0.4-0.1,0.7-0.3,1.1-0.5c0.1-0.1,0.3-0.1,0.4-0.2c0.5-0.2,0.9-0.4,1.4-0.6   c0,0,0,0,0,0V441.2z M415,259.3c38.8,0,59,9.1,61.2,13c0,0,0,0.1-0.1,0.1c0,0.1-0.1,0.1-0.1,0.2c0,0.1-0.1,0.1-0.2,0.2   c-0.1,0.1-0.1,0.1-0.2,0.2c-0.1,0.1-0.1,0.1-0.2,0.2c-0.1,0.1-0.2,0.1-0.2,0.2c-0.1,0.1-0.2,0.1-0.3,0.2c-0.1,0.1-0.2,0.2-0.3,0.2   c-0.1,0.1-0.2,0.2-0.3,0.2c-0.1,0.1-0.2,0.2-0.4,0.2c-0.1,0.1-0.2,0.2-0.4,0.2c-0.1,0.1-0.3,0.2-0.4,0.3c-0.1,0.1-0.3,0.2-0.4,0.2   c-0.2,0.1-0.3,0.2-0.5,0.3c-0.2,0.1-0.3,0.2-0.5,0.3c-0.2,0.1-0.3,0.2-0.5,0.3c-0.2,0.1-0.3,0.2-0.5,0.3c-0.2,0.1-0.4,0.2-0.6,0.3   c-0.2,0.1-0.4,0.2-0.6,0.3c-0.2,0.1-0.4,0.2-0.6,0.3c-0.2,0.1-0.4,0.2-0.6,0.3c-0.2,0.1-0.5,0.2-0.7,0.3c-0.2,0.1-0.5,0.2-0.7,0.3   c-0.2,0.1-0.5,0.2-0.7,0.3c-0.2,0.1-0.5,0.2-0.7,0.3c-0.3,0.1-0.5,0.2-0.8,0.3c-0.3,0.1-0.5,0.2-0.8,0.3c-0.3,0.1-0.6,0.2-0.8,0.3   c-0.3,0.1-0.6,0.2-0.8,0.3c-0.3,0.1-0.6,0.2-0.9,0.3c-0.3,0.1-0.6,0.2-0.9,0.3c-0.3,0.1-0.6,0.2-1,0.3c-0.3,0.1-0.6,0.2-1,0.3   c-0.3,0.1-0.7,0.2-1,0.3c-0.3,0.1-0.7,0.2-1,0.3c-0.3,0.1-0.7,0.2-1,0.2c-0.4,0.1-0.7,0.2-1.1,0.2c-0.4,0.1-0.7,0.2-1.1,0.2   c-0.4,0.1-0.8,0.2-1.1,0.2c-0.4,0.1-0.8,0.2-1.2,0.2c-0.4,0.1-0.8,0.1-1.2,0.2c-0.4,0.1-0.8,0.1-1.2,0.2c-0.4,0.1-0.8,0.1-1.3,0.2   c-0.4,0.1-0.8,0.1-1.2,0.2c-0.4,0.1-0.9,0.1-1.4,0.2c-0.4,0.1-0.8,0.1-1.3,0.2c-0.5,0.1-0.9,0.1-1.4,0.2c-0.4,0.1-0.9,0.1-1.3,0.2   c-0.5,0.1-1,0.1-1.5,0.2c-0.5,0.1-0.9,0.1-1.4,0.2c-0.5,0.1-1,0.1-1.6,0.2c-0.5,0-0.9,0.1-1.4,0.1c-0.5,0.1-1.1,0.1-1.7,0.1   c-0.5,0-0.9,0.1-1.4,0.1c-0.6,0-1.2,0.1-1.8,0.1c-0.5,0-0.9,0.1-1.4,0.1c-0.6,0-1.2,0.1-1.8,0.1c-0.5,0-0.9,0.1-1.4,0.1   c-0.6,0-1.3,0.1-2,0.1c-0.5,0-0.9,0-1.4,0.1c-0.8,0-1.5,0-2.3,0.1c-0.4,0-0.8,0-1.2,0c-1.2,0-2.4,0-3.6,0s-2.4,0-3.6,0   c-0.4,0-0.8,0-1.2,0c-0.8,0-1.6,0-2.3-0.1c-0.5,0-0.9,0-1.4-0.1c-0.7,0-1.3,0-2-0.1c-0.5,0-1-0.1-1.5-0.1c-0.6,0-1.2-0.1-1.8-0.1   c-0.5,0-1-0.1-1.4-0.1c-0.6,0-1.2-0.1-1.7-0.1c-0.5,0-0.9-0.1-1.4-0.1c-0.6,0-1.1-0.1-1.7-0.1c-0.5,0-0.9-0.1-1.4-0.1   c-0.5-0.1-1.1-0.1-1.6-0.2c-0.5,0-0.9-0.1-1.3-0.2c-0.5-0.1-1-0.1-1.5-0.2c-0.4-0.1-0.9-0.1-1.3-0.2c-0.5-0.1-1-0.1-1.4-0.2   c-0.4-0.1-0.8-0.1-1.2-0.2c-0.5-0.1-0.9-0.1-1.4-0.2c-0.4-0.1-0.8-0.1-1.2-0.2c-0.4-0.1-0.9-0.1-1.3-0.2c-0.4-0.1-0.8-0.1-1.1-0.2   c-0.4-0.1-0.8-0.2-1.3-0.2c-0.4-0.1-0.7-0.1-1.1-0.2c-0.4-0.1-0.8-0.2-1.2-0.2c-0.4-0.1-0.7-0.2-1.1-0.2c-0.4-0.1-0.8-0.2-1.1-0.3   c-0.3-0.1-0.7-0.2-1-0.2c-0.4-0.1-0.7-0.2-1.1-0.3c-0.3-0.1-0.6-0.2-1-0.2c-0.3-0.1-0.7-0.2-1-0.3c-0.3-0.1-0.6-0.2-0.9-0.3   c-0.3-0.1-0.6-0.2-1-0.3c-0.3-0.1-0.6-0.2-0.9-0.3c-0.3-0.1-0.6-0.2-0.9-0.3c-0.3-0.1-0.5-0.2-0.8-0.3c-0.3-0.1-0.6-0.2-0.8-0.3   c-0.3-0.1-0.5-0.2-0.8-0.3c-0.3-0.1-0.5-0.2-0.8-0.3c-0.2-0.1-0.5-0.2-0.7-0.3c-0.2-0.1-0.5-0.2-0.7-0.3c-0.2-0.1-0.4-0.2-0.6-0.3   c-0.2-0.1-0.5-0.2-0.7-0.3c-0.2-0.1-0.4-0.2-0.6-0.3c-0.2-0.1-0.4-0.2-0.6-0.3c-0.2-0.1-0.4-0.2-0.5-0.3c-0.2-0.1-0.4-0.2-0.6-0.3   c-0.2-0.1-0.3-0.2-0.5-0.3c-0.2-0.1-0.3-0.2-0.5-0.3c-0.2-0.1-0.3-0.2-0.4-0.2c-0.2-0.1-0.3-0.2-0.4-0.3c-0.1-0.1-0.3-0.2-0.4-0.2   c-0.1-0.1-0.3-0.2-0.4-0.3c-0.1-0.1-0.2-0.2-0.3-0.2c-0.1-0.1-0.2-0.2-0.3-0.2c-0.1-0.1-0.2-0.1-0.3-0.2c-0.1-0.1-0.2-0.2-0.3-0.2   c-0.1-0.1-0.2-0.1-0.2-0.2c-0.1-0.1-0.2-0.2-0.2-0.2c-0.1-0.1-0.1-0.1-0.2-0.2c-0.1-0.1-0.1-0.1-0.2-0.2c0-0.1-0.1-0.1-0.1-0.2   c0,0,0-0.1-0.1-0.1C356,268.4,376.2,259.3,415,259.3z M125.6,58c0-0.1,0.1-0.3,0.2-0.4c0,0,0,0,0.1,0h170.9c0.1,0,0.2,0,0.2,0   c0,0,0.1,0.2,0.1,0.3c-37,15.1-53.5,46.7-58.7,58.9h-53.7C180.5,106.1,166.9,82,125.6,58z M145.9,136.8c3.9-3.9,9-6,14.5-6h19.2   h63.6h19.2c11.3,0,20.5,9.2,20.5,20.4c0,5.5-2.1,10.6-6,14.4c-3.9,3.9-9,6-14.5,6H262H160.7h-0.4c-11.3,0-20.5-9.2-20.5-20.4   C139.9,145.8,142.1,140.7,145.9,136.8z M38.9,413.5l30.2-25.4c1.4-1.2,2.3-2.9,2.5-4.7c2.7-28.3,9-70.1,23.6-109.2   c16.2-43.5,38.9-73.3,67.3-88.6h97.8c45.7,24.6,68.4,83,79.4,128.3v14.6V385v45.1H42.5c-3.9,0-5.6-3.6-6.2-5.1   C35.1,421.4,35.4,416.5,38.9,413.5z"/>
                                                                        <path class="st0"
                                                                              d="M177,351.2c8.8,6.2,18.7,10.1,29.5,11.2v8.9c0,3.4,2.9,6.2,6.3,6.2c3.5,0,6.2-2.7,6.2-6.2v-8.6   c18.3-1.7,30.7-12.2,30.7-28.1c0-4.7-0.9-8.9-2.8-12.4c-4.2-8.1-13.3-13.4-28.5-17.2v-27.6c4.9,1.1,9.8,3.3,14.8,6.3   c1.4,0.9,2.9,1.3,4.3,1.3c4.5,0,8.1-3.5,8.1-7.9c0-3.4-2-5.6-4.3-6.9c-6.6-4.2-13.8-6.9-22.3-7.9V259c0-3.4-2.7-6.2-6.2-6.2   c-3.4,0-6.3,2.7-6.3,6.2v3c-5.7,0.5-10.8,1.8-15.1,4c-5.4,2.7-9.5,6.5-12.1,11.3c-2,3.6-3,7.7-3,12.2c0,6.6,1.6,11.8,4.9,16.1   c4.9,6.2,13.4,10.3,25.9,13.6v28.4c-7.9-1.4-14.5-4.7-21.3-9.6c-1.3-1-3-1.6-4.7-1.6c-4.5,0-7.9,3.4-7.9,7.9   C173.1,347.3,174.5,349.6,177,351.2z M218.4,321.9c0.2,0.1,0.5,0.1,0.7,0.2c10.5,3.4,13.6,7.3,13.6,13.5c0,6.9-5,11.5-14.2,12.5   V321.9z M201.3,299.7C201.3,299.7,201.3,299.7,201.3,299.7c-6.3-3-8.1-6.4-8.1-11.2c0-6.3,4.6-11.2,13.8-12.1v25.5   C204.8,301.2,202.9,300.5,201.3,299.7z"/>
                                                                    </g>
                          </svg>
                                                                <div class="font-medium-5 font-weight-bold mt-2 primary">
                                                                    {{ $plan->name }}
                                                                </div>
                                                                <div class="annual-plan">
                                                                    <div class="plan-price mt-2">
                                                                        <span class="font-large-1 font-weight-bold">{{ \App\Library\Tool::format_price($plan->price, $plan->currency->format) }}</span>
                                                                        <span class="d-block font-weight-bold">{{ $plan->displayFrequencyTime() }}</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- premium card top area ends -->

                                                        <!-- premium plan limits value starts -->
                                                        <div class="plan-limits mt-2 pt-25">

                                                            <div class="d-flex justify-content-center align-items-center common-height-limit">
                                                                <span class="font-medium-4 text-truncate text-uppercase">{{ $plan->displayTotalQuota() }}</span>
                                                            </div>

                                                            <div class="d-flex justify-content-center align-items-center common-height-limit">
                                                                <span class="font-medium-4 text-truncate">
                                                                    @if($plan->getOption('create_sending_server') == 'yes')
                                                                        {{__('locale.labels.yes')}}
                                                                    @else
                                                                        {{__('locale.labels.no')}}
                                                                    @endif
                                                                </span>
                                                            </div>

                                                            <div class="d-flex justify-content-center align-items-center common-height-limit">
                                                                <span class="font-medium-4 text-truncate">
                                                                    @if($plan->getOption('sender_id_verification') == 'yes')
                                                                        {{__('locale.labels.yes')}}
                                                                    @else
                                                                        {{__('locale.labels.no')}}
                                                                    @endif
                                                                </span>
                                                            </div>

                                                            <div class="d-flex justify-content-center align-items-center common-height-limit">
                                                                <span class="font-medium-4 text-truncate">
                                                                    @if($plan->getOption('api_access') == 'yes')
                                                                        {{__('locale.labels.yes')}}
                                                                    @else
                                                                        {{__('locale.labels.no')}}
                                                                    @endif
                                                                </span>
                                                            </div>


                                                            <div class="d-flex justify-content-center align-items-center common-height-limit">
                                                                <span class="font-medium-1 text-truncate text-uppercase">{{ $plan->getOption('plain_sms') }} {{__('locale.labels.credit_per_sms')}}</span>
                                                            </div>

                                                            <div class="d-flex justify-content-center align-items-center common-height-limit">
                                                                <span class="font-medium-1 text-truncate text-uppercase">{{ $plan->getOption('voice_sms') }} {{__('locale.labels.credit_per_sms')}}</span>
                                                            </div>

                                                            <div class="d-flex justify-content-center align-items-center common-height-limit">
                                                                <span class="font-medium-1 text-truncate text-uppercase">{{ $plan->getOption('mms_sms') }} {{__('locale.labels.credit_per_sms')}}</span>
                                                            </div>
                                                            <div class="btn-subscribe-now">
                                                                <a href="{{ route('customer.subscriptions.purchase', $plan->uid) }}" class="btn  {{ $plan->is_popular ? "btn-primary" : "btn-outline-primary" }}
                                                                        btn-lg" {{ isset($subscription) && $plan->id == $subscription->plan_id ? "disabled" : "" }}>

                                                                    {{ isset($subscription) && $plan->id == $subscription->plan_id ? __('locale.labels.current_plan') : __('locale.labels.subscribe_now') }}
                                                                </a>
                                                            </div>
                                                        </div>
                                                        <!-- premium plan limits value ends -->
                                                    </div>
                                                </div>
                                                <!-- premium plan ends -->
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

@endsection

